// Copyright 2014 Google Inc. All Rights Reserved.

#ifndef ANDROID_AUTO_PROJECTION_PROTOCOL_LOG_H
#define ANDROID_AUTO_PROJECTION_PROTOCOL_LOG_H

#define GAL_RECEIVER_LOG_TAG            "GalReceiver"

#ifdef __ANDROID__

#include <android/log.h>

#define LOGE(...) __android_log_print(ANDROID_LOG_ERROR, GAL_RECEIVER_LOG_TAG, __VA_ARGS__)
#define LOGW(...) __android_log_print(ANDROID_LOG_WARN, GAL_RECEIVER_LOG_TAG, __VA_ARGS__)
#define LOGI(...) __android_log_print(ANDROID_LOG_INFO, GAL_RECEIVER_LOG_TAG, __VA_ARGS__)
#define LOGD(...) __android_log_print(ANDROID_LOG_DEBUG, GAL_RECEIVER_LOG_TAG, __VA_ARGS__)

#elif __QNXNTO__

#include <sys/slog.h>
#include <sys/slogcodes.h>

#define LOGE(...) slogf(_SLOG_SETCODE(_SLOGC_TEST, 1), _SLOG_ERROR,__VA_ARGS__)
#define LOGW(...) slogf(_SLOG_SETCODE(_SLOGC_TEST, 1), _SLOG_WARNING,__VA_ARGS__)
#define LOGI(...) slogf(_SLOG_SETCODE(_SLOGC_TEST, 1), _SLOG_INFO,__VA_ARGS__)
#define LOGD(...) slogf(_SLOG_SETCODE(_SLOGC_TEST, 1), _SLOG_DEBUG1,__VA_ARGS__)

// Changed by ADIT
#elif (defined(ADIT_LOGGING_DLT) || defined(ADIT_LOGGING_PRINTF) || defined(ADIT_LOGGING_OFF))

#include <stdio.h> // required as sources including Log.h rely on indirect inclusion of stdio.h

typedef int (*adit_aauto_log_t)(int log_level, va_list args);
void set_aauto_log_fn(adit_aauto_log_t fcnPtr);

int adit_aauto_log(int log_level...);

#define LOGE(...) adit_aauto_log(1, __VA_ARGS__)
#define LOGW(...) adit_aauto_log(2, __VA_ARGS__)
#define LOGI(...) adit_aauto_log(3, __VA_ARGS__)
#define LOGD(...) adit_aauto_log(4, __VA_ARGS__)

#else

#include <stdio.h>

#define LOGE(...) fprintf(stderr, __VA_ARGS__), fprintf(stderr, "\n")
#define LOGW(...) fprintf(stderr, __VA_ARGS__), fprintf(stderr, "\n")
#define LOGI(...) fprintf(stderr, __VA_ARGS__), fprintf(stderr, "\n")
#define LOGD(...) fprintf(stderr, __VA_ARGS__), fprintf(stderr, "\n")

#endif // #ifdef __ANDROID__


#endif // ANDROID_AUTO_PROJECTION_PROTOCOL_LOG_H
